/*******************************************************
	Author: 
		Liu Caiquan
	Date: 
		@8th-December-2016@

	CarLife Protocol version:
		@V1.2.4@
							Copyright (C) Under BaiDu, Inc.
*******************************************************/
#include"CConnectManager.h"
#include"CVirtualShell.h"
#include"CCarLifeLog.h"
#include "CProtocolFactory.h"
#include "CCarLifeLib.h"
#include "IProtocolSocketConnector.h"
// all the logging messages in this file are replaced to DLT by ADIT
LOG_IMPORT_CONTEXT(bdcl_core) //added by ADIT

using namespace std;

CConnectManager* CConnectManager::pInstance=NULL;
CmdRet CConnectManager::cmdRet;

CConnectManager::CConnectManager(){
	cmdSocket=NULL;
	videoSocket=NULL;
	mediaSocket=NULL;
	ttsSocket=NULL;
	vrSocket=NULL;
	ctrlSocket=NULL;
}

CConnectManager::~CConnectManager(){
    //tbd: need to understand sequence of destructor calls
    //     when ~eapSocket() is triggered. Main idea is to
    //     terminate receivepacket worker thread before
    //     terminating other channel threads
    CProtocolFactory::destroy();
    aProtocolHandler=NULL;

	delete cmdSocket;
	cmdSocket=NULL;

	delete videoSocket;
	videoSocket=NULL;

	delete mediaSocket;
	mediaSocket=NULL;

	delete ttsSocket;
	ttsSocket=NULL;

	delete vrSocket;
	vrSocket=NULL;

	delete ctrlSocket;
	ctrlSocket=NULL;

	pInstance=NULL;
}

CConnectManager* CConnectManager::getInstance(){
	if(NULL==pInstance){
		pInstance=new CConnectManager();
		}

	return pInstance;
}

bool CConnectManager::startBdclServerAsRoot(){

	return true;
}

bool CConnectManager::execGetDeviceCmd(){
	return true;
}

bool CConnectManager::execSocketForward(){
	CVirtualShell::getInstance()->doCmdWithResult(ADB_FORWARD_CMD, &cmdRet);
	CVirtualShell::getInstance()->doCmdWithResult(ADB_FORWARD_VIDEO, &cmdRet);
	CVirtualShell::getInstance()->doCmdWithResult(ADB_FORWARD_MEDIA, &cmdRet);
	CVirtualShell::getInstance()->doCmdWithResult(ADB_FORWARD_TTS, &cmdRet);
	CVirtualShell::getInstance()->doCmdWithResult(ADB_FORWARD_VR, &cmdRet);
	CVirtualShell::getInstance()->doCmdWithResult(ADB_FORWARD_TOUCH, &cmdRet);

	//for testing
	/*
	CVirtualShell::getInstance()->doCmdWithResult("ps", &cmdRet);
	cout<<"ps return result: "<<endl;
	for(int i=0; i<cmdRet.len;i++){
		cout<<cmdRet.data[i]<<" ";
	}
	cout<<endl;
	*/
	
	return true;
}

bool CConnectManager::execGetPropCmd(){
	return true;
}

bool CConnectManager::execStartCarlife(){
	return true;
}

bool CConnectManager::execKillBdsc(){
	return true;
}

bool CConnectManager::execStartBdsc(){
	return true;
}

// ADIT modified
void CConnectManager::wakeupThreads()
{
  if(aProtocolHandler)
    {
      aProtocolHandler->wakeupThreads();
    }
}


// ADIT modified
bool CConnectManager::createProtocolConnector(int accOrWrId, int devOrRdId, deviceType inDevice){ //modified by ADIT
    LOG_INFO((bdcl_core,"recieved Accessory ID/Write Id = %d and Device ID/Read Id =%d",accOrWrId, devOrRdId));
    aProtocolHandler = static_cast<IProtocolSocketConnector*> (CProtocolFactory::getInstance(inDevice));
	if(aProtocolHandler != NULL){
	if(aProtocolHandler->connect(accOrWrId, devOrRdId)){
	    LOGD_DEBUG((bdcl_core,"Accessory Id/Write Fd and Device Id/Read Fd set Successfully"));
		return true;
	}else{
	    LOG_ERROR((bdcl_core,"Accessory Id/Write Fd and Device Id/Read Fd set Failed"));
		return false;
	}
	}else{
	    LOG_ERROR((bdcl_core,"createProtocolConnector Failed"));
    return false;
	}
}

//cmd
// modified by ADIT
bool CConnectManager::createCmdSocket(){

	cmdSocket=new ASocketConnector(aProtocolHandler,1);

	if(cmdSocket != NULL)
	{
	    return true;
	}
	else
	{
		delete cmdSocket;
		cmdSocket=NULL;
	    return false;
	}


}

bool CConnectManager::createCmdSocket(string mdIPAddress){
	cmdSocket=new ASocketConnector(mdIPAddress, CMD_SOCKET_PORT_MD, ""); //modified by ADIT

	if(cmdSocket->connectToServer()){
		return true;
	}else{
		delete cmdSocket;
		cmdSocket=NULL;
		return false;
	}
}

bool CConnectManager::createCmdSocket(string mdIPAddress, string interfaceName){
	cmdSocket=new ASocketConnector(mdIPAddress, CMD_SOCKET_PORT_MD, interfaceName);//modified by ADIT

	if(cmdSocket->connectToServer()){
		return true;
	}else{
		delete cmdSocket;
		cmdSocket=NULL;
		return false;
	}
}


//video
//modified by ADIT
bool CConnectManager::createVideoSocket(){
	videoSocket=new ASocketConnector(aProtocolHandler, 2);

	if(videoSocket != NULL)
	{
        return true;
        }
    else
    {
		delete videoSocket;
		videoSocket=NULL;
        return false;
    }
}
bool CConnectManager::createVideoSocket(string mdIPAddress){
	videoSocket=new ASocketConnector(mdIPAddress, VIDEO_SOCKET_PORT_MD, "");//modified by ADIT

	if(videoSocket->connectToServer()){
		return true;
	}else{
		delete videoSocket;
		videoSocket=NULL;
		return false;
	}
}

bool CConnectManager::createVideoSocket(string mdIPAddress, string interfaceName){
	videoSocket=new ASocketConnector(mdIPAddress, VIDEO_SOCKET_PORT_MD, interfaceName);//modified by ADIT

	if(videoSocket->connectToServer()){
		return true;
	}else{
		delete videoSocket;
		videoSocket=NULL;
		return false;
	}
}

//media
//modified by ADIT
bool CConnectManager::createMediaSocket(){
	mediaSocket=new ASocketConnector(aProtocolHandler, 3);

	if(mediaSocket != NULL)
    {
        return true;
    }
    else
    {
        delete mediaSocket;
		mediaSocket=NULL;
        return false;
    }
}
bool CConnectManager::createMediaSocket(string mdIPAddress){
	mediaSocket=new ASocketConnector(mdIPAddress, MEDIA_SOCKET_PORT_MD, "");//modified by ADIT

	if(mediaSocket->connectToServer()){
		return true;
	}else{
		delete mediaSocket;
		mediaSocket=NULL;
		return false;
	}
}

bool CConnectManager::createMediaSocket(string mdIPAddress, string interfaceName){
	mediaSocket=new ASocketConnector(mdIPAddress, MEDIA_SOCKET_PORT_MD, interfaceName);//modified by ADIT

	if(mediaSocket->connectToServer()){
		return true;
	}else{
		delete mediaSocket;
		mediaSocket=NULL;
		return false;
	}
}

//navi tts
bool CConnectManager::createTTSSocket(){
	ttsSocket=new ASocketConnector(aProtocolHandler, 4);

	if(ttsSocket != NULL)
    {
        return true;
    }
    else
    {
        delete ttsSocket;
		ttsSocket=NULL;
        return false;
    }
}
bool CConnectManager::createTTSSocket(string mdIPAddress){
	ttsSocket=new ASocketConnector(mdIPAddress, TTS_SOCKET_PORT_MD, "");//modified by ADIT

	if(ttsSocket->connectToServer()){
		return true;
	}else{
		delete ttsSocket;
		ttsSocket=NULL;
		return false;
	}
}

bool CConnectManager::createTTSSocket(string mdIPAddress, string interfaceName){
	ttsSocket=new ASocketConnector(mdIPAddress, TTS_SOCKET_PORT_MD, interfaceName);//modified by ADIT

	if(ttsSocket->connectToServer()){
		return true;
	}else{
		delete ttsSocket;
		ttsSocket=NULL;
		return false;
	}
}

//vr
//modified by ADIT
bool CConnectManager::createVRSocket(){
	vrSocket=new ASocketConnector(aProtocolHandler, 5);

	if(vrSocket != NULL)
    {
        return true;
    }
    else
    {
        delete vrSocket;
		vrSocket=NULL;
        return false;
    }
}
bool CConnectManager::createVRSocket(string mdIPAddress){
	vrSocket=new ASocketConnector(mdIPAddress, VR_SOCKET_PORT_MD, "");//modified by ADIT

	if(vrSocket->connectToServer()){
		return true;
	}else{
		delete vrSocket;
		vrSocket=NULL;
		return false;
	}
}

bool CConnectManager::createVRSocket(string mdIPAddress, string interfaceName){
	vrSocket=new ASocketConnector(mdIPAddress, VR_SOCKET_PORT_MD, interfaceName);//modified by ADIT

	if(vrSocket->connectToServer()){
		return true;
	}else{
		delete vrSocket;
		vrSocket=NULL;
		return false;
	}
}

//toutch
//modified by ADIT
bool CConnectManager::createTouchSocket(){
	ctrlSocket=new ASocketConnector(aProtocolHandler, 6);

	if(ctrlSocket != NULL)
    {
        return true;
    }
    else
    {
        delete ctrlSocket;
		ctrlSocket=NULL;
        return false;
    }
}
bool CConnectManager::createTouchSocket(string mdIPAddress){
	ctrlSocket=new ASocketConnector(mdIPAddress, TOUCH_SOCKET_PORT_MD, "");//modified by ADIT

	if(ctrlSocket->connectToServer()){
		return true;
	}else{
		delete ctrlSocket;
		ctrlSocket=NULL;
		return false;
	}
}

bool CConnectManager::createTouchSocket(string mdIPAddress, string interfaceName){
	ctrlSocket=new ASocketConnector(mdIPAddress, TOUCH_SOCKET_PORT_MD, interfaceName);//modified by ADIT

	if(ctrlSocket->connectToServer()){
		return true;
	}else{
		delete ctrlSocket;
		ctrlSocket=NULL;
		return false;
	}
}

bool CConnectManager::readCmdData(u8* data, u32 len){
////////// modifed by ADIT
	if (NULL == cmdSocket) {
		LOG_ERROR((bdcl_core,"cmdSocket is null!"));
		return false;
	}
	if (!cmdSocket->recv(data, len)) {
		cmdSocket->setConnectStatus(false);
		LOG_INFO((bdcl_core,"CMD socket.recv is failed!"));
		return false;
	}

	return true;
}
bool CConnectManager::writeCmdData(u8* data, u32 len){
/////////////// modified by ADIT
	if (NULL == cmdSocket) {
		LOG_ERROR((bdcl_core,"cmdSocket is null!"));
		return false;
	}
	if (!cmdSocket->send(data, len)) { //modified by ADIT
		cmdSocket->setConnectStatus(false);
		LOG_ERROR((bdcl_core,"Cmd socket.send is failed!"));
		return false;
	}

	return true;
}

bool CConnectManager::readVideoData(u8* data, u32 len){
	////////// modifed by ADIT
	if (NULL == videoSocket) {
		LOG_ERROR((bdcl_core,"videoSocket is null!"));
		return false;
	}
	if (!videoSocket->recv(data, len)) {
		videoSocket->setConnectStatus(false);
		LOG_INFO((bdcl_core,"Video socket.recv is failed!"));
		return false;
	}
	return true;
}

/////// added by ADIT
bool CConnectManager::writeVideoData(u8* data, u32 len){
	if (NULL == videoSocket) {
		LOG_ERROR((bdcl_core,"videoSocket is null!"));
		return false;
	}
	if (!videoSocket->send(data, len)) {
		videoSocket->setConnectStatus(false);
		LOG_ERROR((bdcl_core,"videoSocket socket.send is failed!"));
		return false;
	}

	return true;
}

bool CConnectManager::readMediaData(u8* data, u32 len){
	////////// modifed by ADIT
	if (NULL == mediaSocket) {
		LOG_ERROR((bdcl_core,"mediaSocket is null!"));
		return false;
	}
	if (!mediaSocket->recv(data, len)) {
		mediaSocket->setConnectStatus(false);
		LOG_INFO((bdcl_core,"Media socket.recv is failed!"));
		return false;
	}
	return true;
}

bool CConnectManager::readTTSData(u8* data, u32 len){
	////////// modifed by ADIT
	if (NULL == ttsSocket) {
		LOG_ERROR((bdcl_core,"ttsSocket is null!"));
		return false;
	}
	if (!ttsSocket->recv(data, len)) {
		ttsSocket->setConnectStatus(false);
		LOG_INFO((bdcl_core,"TTS socket.recv is failed!"));
		return false;
	}
	return true;
}

bool CConnectManager::readVRData(u8* data, u32 len){
	////////// modifed by ADIT

	if (NULL == vrSocket) {
		LOG_ERROR((bdcl_core,"VR Socket is null!"));
		return false;
	}
	if (!vrSocket->recv(data, len)) {
		vrSocket->setConnectStatus(false);
		LOG_INFO((bdcl_core,"VR socket.recv is failed!"));
		return false;
	}
	return true;
}

bool CConnectManager::writeVRData(u8* data, u32 len){
	/////////////// modified by ADIT
		if (NULL == vrSocket) {
			LOG_ERROR((bdcl_core,"VR Socket is null!"));
			return false;
		}
		if (!vrSocket->send(data, len)) { //modified by ADIT
		vrSocket->setConnectStatus(false);
			LOG_ERROR((bdcl_core,"VR socket.send is failed!"));
			return false;
		}

		return true;

	return true;
}

bool CConnectManager::writeCtrlData(u8*data, u32 len){
	/////////////// modified by ADIT
		if (NULL == ctrlSocket) {
			LOG_ERROR((bdcl_core,"ctrlSocket is null!"));
			return false;
		}
		if (!ctrlSocket->send(data, len)) { //modified by ADIT
		ctrlSocket->setConnectStatus(false);
			LOG_ERROR((bdcl_core,"Ctrl socket.send is failed!"));
			return false;
		}

		return true;
}
